import sys
import os

# Ruta absoluta al directorio raíz de tu proyecto (ajusta si es necesario)
project_dir = os.path.dirname(os.path.abspath(__file__))
sys.path.insert(0, project_dir)

# Si tu aplicación está en una subcarpeta llamada 'app', añade esa ruta también
app_dir = os.path.join(project_dir, 'app')
if app_dir not in sys.path:
    sys.path.insert(0, app_dir)

# Establece la variable de entorno para Flask si usas configuración específica
os.environ['FLASK_APP'] = 'app'
# Si tienes configuración por entorno, puedes añadir:
# os.environ['FLASK_ENV'] = 'production'

# Importa y crea la aplicación usando el factory pattern
from app import create_app

application = create_app()